<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
?>
<div class="woo_discount_loader_outer awdr-container">
    <div class="awdr-documentation-title" style="padding: 15px;">
            <h3><?php esc_html_e('Documentation', 'woo-discount-rules');?></h3>
        <hr>
    </div>
    <div class="awdr-three-column-document-head">
        <div class="awdr-first-column awdr-three-column-inner">
            <div style="padding-left: 10px;">
                <h4>
                    <?php esc_html_e(' Installation & Introduction', 'woo-discount-rules');?>
                </h4>
                <hr/>
            </div>
            <div class="row form-group enable_variable_product_cache_con">
                <div class="awdr-hr-line">
                    <div class="wdr_read_documentation_con"><a class="wdr_read_documentation"
                                                               href="https://docs.flycart.org/en/articles/3798255-installation?utm_source=woo-discount-rules-v2&utm_campaign=doc&utm_medium=text-click&utm_content=Installation_documentation"
                                                               target="_blank"><?php esc_html_e('Installation', 'woo-discount-rules');?></a>
                        <p class=""><?php esc_html_e('Installation of Advanced discount rules', 'woo-discount-rules');?></p></div>

                    <hr>
                </div>
                <div class="awdr-hr-line">
                    <div class="wdr_read_documentation_con"><a class="wdr_read_documentation"
                                                               href="https://docs.flycart.org/en/articles/2088290-license-key-activation?utm_source=woo-discount-rules-v2&utm_campaign=doc&utm_medium=text-click&utm_content=license_key_activation"
                                                               target="_blank"><?php esc_html_e('License Key activation', 'woo-discount-rules');?></a>
                        <p class=""><?php esc_html_e('Learn how to obtain the license key and activate it', 'woo-discount-rules');?></p></div>
                    <hr>

                </div>
                <div class="awdr-hr-line">
                    <div class="wdr_read_documentation_con"><a class="wdr_read_documentation"
                                                               href="https://docs.flycart.org/en/articles/2258499-version-updates?utm_source=woo-discount-rules-v2&utm_campaign=doc&utm_medium=text-click&utm_content=version-updates"
                                                               target="_blank"><?php esc_html_e('Version Updates!', 'woo-discount-rules');?></a>
                        <p class=""><?php esc_html_e('Learn how to update to latest versions', 'woo-discount-rules');?></p></div>
                    <hr/>
                </div>
                <div class="awdr-hr-line">
                    <div class="wdr_read_documentation_con"><a class="wdr_read_documentation"
                                                               href="https://docs.flycart.org/en/articles/4849528-how-to-set-up-discount-rules?utm_source=woo-discount-rules-v2&utm_campaign=doc&utm_medium=text-click&utm_content=how-to-set-up-discount-rules"
                                                               target="_blank"><?php esc_html_e('Setting up Discount Rules', 'woo-discount-rules');?></a>
                        <p class=""><?php esc_html_e("Let's Learn how to decide on setting up a discount and configuring the same", 'woo-discount-rules');?></p></div>
                    <hr/>
                </div>

            </div>
        </div>
        <div class="awdr-second-column awdr-three-column-inner">
            <div style="padding-left: 10px;">
                <h4>
                   <?php esc_html_e('Price rules/BOGO discounts', 'woo-discount-rules');?>
                </h4>
                <hr/>
            </div>
            <div class="row form-group enable_variable_product_cache_con">
                <div class="awdr-hr-line">
                    <div class="wdr_read_documentation_con"><a class="wdr_read_documentation"
                                                               href="https://docs.flycart.org/en/articles/3807208-bulk-discounts-or-tiered-pricing"
                                                               target="_blank"><?php esc_html_e('Bulk/Tiered pricing discounts', 'woo-discount-rules');?></a>
                        <p class=""><?php esc_html_e('Learn how to create bulk/tiered quantity discounts in WooCommerce', 'woo-discount-rules');?></p></div>
                    <hr/>
                </div>




                <div class="awdr-hr-line">
                    <div class="wdr_read_documentation_con"><a class="wdr_read_documentation"
                                                               href="https://docs.flycart.org/en/articles/4035579-free-product-auto-add-auto-remove?utm_source=woo-discount-rules&utm_campaign=doc&utm_medium=text-click&utm_content=free-product-auto-add-auto-remove-discount-rules-2-0"
                                                               target="_blank"><?php esc_html_e('How to create a perfect BOGO discount rule in WooCommerce', 'woo-discount-rules');?></a>
                        <p class=""><?php esc_html_e('Buy One Get One deals can be simple to complex. Learn how to get them working correct in your online store', 'woo-discount-rules');?></p></div>
                    <hr/>
                </div>



                <div class="awdr-hr-line">
                    <div class="wdr_read_documentation_con"><a class="wdr_read_documentation"
                                                               href="https://docs.flycart.org/en/collections/807112-coupon-based-discounts"
                                                               target="_blank"><?php esc_html_e('Coupon code based discounts', 'woo-discount-rules');?></a>
                        <p class=""><?php esc_html_e('Apply the dynamic discount rules after the customer enters a valid coupon code', 'woo-discount-rules');?></p></div>
                    <hr/>
                </div>

                <div class="awdr-hr-line">
                    <div class="wdr_read_documentation_con"><a class="wdr_read_documentation"
                                                               href="https://docs.flycart.org/en/articles/4210448-buy-one-get-one-discount-for-products-from-same-category?utm_source=woo-discount-rules&utm_campaign=doc&utm_medium=text-click&utm_content=buy-one-get-one-discount-for-products-from-same-category-2-0"
                                                               target="_blank"><?php esc_html_e('Buy One Get One Discount for Products from Same Category', 'woo-discount-rules');?></a>
                        <p class=""><?php esc_html_e('Learn how to offer Buy 2 from Category A and get 1 free from the same Category A', 'woo-discount-rules');?></p></div>
                    <hr/>
                </div>


            </div>
        </div>
        <div class="awdr-third-column awdr-three-column-inner">
           <div style="padding-left: 10px;">
                <h4>
                    <?php esc_html_e('Cart Based Rules', 'woo-discount-rules');?>
                </h4>
               <hr/>
            </div>
            <div class="row form-group enable_variable_product_cache_con">
                <div class="awdr-hr-line">
                    <div class="wdr_read_documentation_con"><a class="wdr_read_documentation"
                                                               href="https://docs.flycart.org/en/articles/3807036-free-shipping?utm_source=woo-discount-rules-v2&utm_campaign=doc&utm_medium=text-click&utm_content=free-shipping-discount-rules-2-0"
                                                               target="_blank"><?php esc_html_e('Free Shipping', 'woo-discount-rules');?></a>
                        <p class=""><?php esc_html_e('Learn how to create a free shipping cart based rule', 'woo-discount-rules');?></p></div>
                    <hr>

                </div>



                <div class="awdr-hr-line">
                    <div class="wdr_read_documentation_con"><a class="wdr_read_documentation"
                                                               href="https://docs.flycart.org/en/articles/3894861-subtotal-based-tiered-discounts?utm_source=woo-discount-rules-v2&utm_campaign=doc&utm_medium=text-click&utm_content=subtotal-based-tiered-discounts-discount-rules-2-0"
                                                               target="_blank"><?php esc_html_e('Subtotal based - Tiered discounts', 'woo-discount-rules');?></a>
                        <p class=""><?php esc_html_e('Learn how to create tiered discount based on the subtotal value', 'woo-discount-rules');?></p></div>
                    <hr>

                </div>




                <div class="awdr-hr-line">
                    <div class="wdr_read_documentation_con"><a class="wdr_read_documentation"
                                                               href="https://docs.flycart.org/en/articles/4214869-discount-based-on-customer-shipping-address?utm_source=woo-discount-rules-v2&utm_campaign=doc&utm_medium=text-click&utm_content=customer-shipping-address-based-discount-2-0"
                                                               target="_blank"><?php esc_html_e(' Shipping address based discount', 'woo-discount-rules');?></a>
                        <p class=""><?php esc_html_e('How to provide a automatic adding free product in cart under certain conditions', 'woo-discount-rules');?></p></div>
                    <hr>

                </div>


                <div class="awdr-hr-line">
                    <div class="wdr_read_documentation_con"><a class="wdr_read_documentation"
                                                               href="https://docs.flycart.org/en/articles/4279899-category-combination-get-discount-only-when-category-a-b-c-are-in-the-cart?utm_source=woo-discount-rules-v2&utm_campaign=doc&utm_medium=text-click&utm_content=category-combination"
                                                               target="_blank"><?php esc_html_e('Category Combination', 'woo-discount-rules');?></a>
                        <p class=""><?php esc_html_e('Category Combination (get discount only when Category A+ B + C are in the cart)', 'woo-discount-rules');?></p></div>
                    <hr>

                </div>



            </div>
        </div>
        <?php
        if(!$is_pro){ ?>
            <div class="awdr-pro-content-card-list">
                <div class="awdr-pro-content-card card" style="float: right;">
                    <div class="card-body text-right">
                        <img class="banner" style="    width: 100%;height: 160px;object-fit: cover;"  src="https://static.flycart.net/recommendation/image/discount-rule.png" <?php //phpcs:ignore PluginCheck.CodeAnalysis.Offloading.OffloadedContent,PluginCheck.CodeAnalysis.ImageFunctions.NonEnqueuedImage  ?>
                             alt="discount-rule-banner-image">
                        <div class="awdr-pro-content-header">
                            <div class="awdr-pro-content-icon">
                                <img src="https://static.flycart.net/recommendation/icons/discount-rules.png" <?php //phpcs:ignore PluginCheck.CodeAnalysis.Offloading.OffloadedContent,PluginCheck.CodeAnalysis.ImageFunctions.NonEnqueuedImage  ?>
                                     alt="discount-rule-icon" width="48" height="48">
                            </div>
                            <h2><?php esc_html_e('Discount Rules PRO for WooCommerce', 'woo-discount-rules') ?></h2>
                        </div>
                        <a href="https://docs.flycart.org/en/articles/3806305-upgrade-from-free-to-pro?utm_source=wpwoodiscountrules&utm_medium=plugin&utm_campaign=inline&utm_content=upgrade"
                           target="_blank"
                           class="btn btn-dark-blue"><?php esc_html_e('Looking for more features? Upgrade to PRO', 'woo-discount-rules'); ?></a>
                        <div class="woo-side-panel mt-3">
                            <div class="panel">
                                <div class="panel-body">
                                    <h3><?php esc_html_e('With PRO version, you can create:', 'woo-discount-rules') ?></h3>
                                    <ul class="list-unstyled">
                                        <li><?php esc_html_e('- Categories based discounts', 'woo-discount-rules') ?></li>
                                        <li><?php esc_html_e('- User roles based discounts', 'woo-discount-rules') ?></li>
                                        <li><?php esc_html_e('- Buy One Get One Free deals', 'woo-discount-rules') ?></li>
                                        <li><?php esc_html_e('- Buy X Get Y deals', 'woo-discount-rules') ?></li>
                                        <li><?php esc_html_e('- Buy 2, get 1 at 50% discount', 'woo-discount-rules') ?></li>
                                        <li><?php esc_html_e('- Buy 3 for $10 (Package / Bundle [Set] Discount)', 'woo-discount-rules') ?></li>
                                        <li><?php esc_html_e('- Different discounts with one coupon code', 'woo-discount-rules') ?></li>
                                        <li><?php esc_html_e('- Purchase history based discounts', 'woo-discount-rules') ?></li>
                                        <li><?php esc_html_e('- Free product / gift', 'woo-discount-rules') ?></li>
                                        <li><?php esc_html_e('- Discount for variants', 'woo-discount-rules') ?></li>
                                        <li><?php esc_html_e('- Conditional discounts', 'woo-discount-rules') ?></li>
                                        <li><?php esc_html_e('- Fixed cost discounts', 'woo-discount-rules') ?></li>
                                        <li><?php esc_html_e('- Offer fixed price on certain conditions', 'woo-discount-rules') ?></li>
                                    </ul>
                                </div>

                                <a href="https://www.flycart.org/products/wordpress/woocommerce-discount-rules?utm_source=wpwoodiscountrules&amp;utm_medium=plugin&amp;utm_campaign=inline&amp;utm_content=woo-discount-rules"
                                   class="btn btn-dark-blue"
                                   target="_blank"><?php esc_html_e('Go PRO', 'woo-discount-rules'); ?></a>
                            </div>
                        </div>
                    </div>
                </div>
		        <?php foreach ($recommended_addon as  $slug => $recommendation) :?>
                    <div class="awdr-pro-content-card card" style="float: right;">
                        <div class="card-body text-right">
                            <div class="awdr-pro-content-header">
                                <div class="awdr-pro-content-icon">
                                    <img src="<?php echo esc_url($recommendation['icon_url']); //phpcs:ignore PluginCheck.CodeAnalysis.ImageFunctions.NonEnqueuedImage	 ?>"
                                         alt="discount-rule-icon" width="48" height="48">
                                </div>
                                <h2><?php echo esc_html($recommendation['name'], 'woo-discount-rules') // phpcs:ignore WordPress.WP.I18n.NonSingularStringLiteralText	?></h2>
                            </div>
                            <div class="description" style="margin-bottom: 6px;">
						        <?php echo esc_html($recommendation['description'], 'woo-discount-rules'); ?>
                            </div>
                            <a href="<?php echo esc_url($recommendation['plugin_url']); ?>"
                               class="btn btn-dark-blue"
                               target="_blank"><?php esc_html_e('Get Plugin', 'woo-discount-rules'); ?></a>
                        </div>
                    </div>
		        <?php endforeach; ?>
            </div>
        <?php } ?>

    </div>

</div>

